/****** Object:  StoredProcedure [dbo].[usp_Get_Discharge_Request]    Script Date: 03/22/2012 11:04:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Get_Discharge_Request]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Get_Discharge_Request]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		SILVICAP	
-- Create date: 24.10.2012
-- Description:	Get discharge request by ID.
-- =============================================
CREATE PROCEDURE [dbo].[usp_Get_Discharge_Request] 
	@ID	INT = NULL,
	@DOMAIN_ID NVARCHAR(50) = NULL
AS
BEGIN
SET NOCOUNT ON

	DECLARE @FACILITY_LIST NVARCHAR(MAX)
	SET @FACILITY_LIST = ''
	-- GET THE LIST OF FACILITIES
	DECLARE @I INT, @ROWCOUNT INT							
	CREATE TABLE #FACILITIES (ID INT, FACILITY_UID UNIQUEIDENTIFIER)

	INSERT INTO #FACILITIES(ID, FACILITY_UID)
	SELECT ROW_NUMBER() OVER (ORDER BY FACILITY_UID), FACILITY_UID 
	FROM ORDER_FACILITY
	WHERE ORDER_ID = @ID AND ORDER_TYPE='DIS'
	
	SET @ROWCOUNT = @@ROWCOUNT

	SET @I = 1
	SET @FACILITY_LIST = COALESCE(@FACILITY_LIST,'')
	WHILE (@I <= @ROWCOUNT)
		BEGIN
			SELECT @FACILITY_LIST = @FACILITY_LIST + CAST(FACILITY_UID AS NVARCHAR(50)) + ',' FROM #FACILITIES WHERE ID = @I
			SET @I = @I + 1
		END

	DROP TABLE #FACILITIES

	SELECT 
			[DR].[ID],
			[DR].[DOMAIN_ID],
			[DR].[IEN],
			[DR].[PATIENT_UID],
			[DR].[ORDERED_DATE],
			[DR].[IS_ACTIVE],
			[DR].[SIGNED_BY_UID],
			[DR].[SIGNED_DATE],
			[DR].[RELEASED_DATE],
			[DR].[SCHEDULER_UID],
			[DR].[PROVIDER_UID],
			[DR].[VISTA_SITE_UID],
			[DR].[HOSPITAL_LOCATION_UID],
			[DR].[WARD_UID],
			[DR].[ORDER_TEXT],
    		[OI].[CODE] AS [ORDERABLE_ITEM_CODE],
			[OI].[CODE_SYSTEM] AS [ORDERABLE_ITEM_CODE_SYSTEM],
			[OI].[CODE_SYSTEM_NAME] AS [ORDERABLE_ITEM_CODE_SYSTEM_NAME],
			[OI].[DISPLAY_NAME] AS [ORDERABLE_ITEM_DISPLAY_NAME],
			@FACILITY_LIST AS [FACILITY_LIST]
	FROM DISCHARGE_REQ DR
		LEFT JOIN CONCEPT AS OI ON OI.ID = DR.ORDERABLE_ITEM_ID
	WHERE [DR].[ID] = @ID AND [DR].[DOMAIN_ID] = @DOMAIN_ID				

END
GO